<?php

namespace App\Http\Controllers;

use App\Http\Requests\MembershipTypeRequest;
use App\Models\Membership;
use App\Models\MembershipType;
use App\Models\Transaction;
use Illuminate\Http\Request;

class MembershipTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        if ($request->has('search')) {
            $keyword = $request->input('search');
            $paginate = false;
            $plans = MembershipType::where('name', 'LIKE', '%' . $keyword . '%')
                ->orWhere('description', 'LIKE', '%' . $keyword . '%')
                ->orderBy('id', 'DESC')->get();

            return view('plan.list', compact('plans', 'paginate'));
        } else {
            $paginate = true;
            $plans = MembershipType::orderBy('id', 'DESC')->paginate(10)->onEachSide(0);
            return view('plan.list', compact('plans', 'paginate'));
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('plan.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(MembershipTypeRequest $request)
    {
        $plan = new MembershipType();
        $plan->name = $request->input('name');
        $plan->amount = (double) $request->input('amount');
        $plan->description = $request->input('description');
        $plan->duration = $request->input('duration');

        $plan->save();

        return back()->with('success', 'Saved successfully');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(MembershipType $plan)
    {
        return view('plan.edit', compact('plan'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(MembershipTypeRequest $request, MembershipType $plan)
    {
        $plan = MembershipType::find($plan->id);
        $plan->name = $request->input('name');
        $plan->amount = $request->input('amount');
        $plan->description = $request->input('description');
        $plan->duration = $request->input('duration');

        $plan->save();

        return redirect()->route('plan.index')->with('success', 'Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(MembershipType $plan)
    {   
        $memberships = $plan->memberships;

        foreach ($memberships as $membership) {
            $transactions = $membership->transactions;
            foreach ($transactions as $transaction) {
                Transaction::where('id', $transaction->id)->delete();
            }
            $membership->delete();
        }
  
        $plan->delete();
        return redirect()->route('plan.index')->with('success', 'Deleted successfully');
    }
}